﻿/////////////////////////////////////////////////
//　置換クエリをメニューにver1.0
//　http://sysys.blog.shinobi.jp/Entry/29/
/////////////////////////////////////////////////

#targetengine "myMenu"
(function(){
var ChangeMenu=app.menus[0].submenus.item("置換");
if (!ChangeMenu.isValid) app.menus[0].submenus.add({name:"置換",title:"置換"});
ChangeMenu.menuElements.everyItem().remove();
with(app.scriptMenuActions) for (var i=0;i<length;i++) if (item(i).label="ChangeMenu") item(i).remove();
var QueriesFolderName=app.scriptPreferences.scriptsFolder.parent.parent.fullName+"/Find-Change Queries";

//クエリ取得
var TextQueries=getDisplayNames(Folder(QueriesFolderName+"/Text").getFiles("*.xml"));
var GREPQueries=getDisplayNames(Folder(QueriesFolderName+"/GREP").getFiles("*.xml"));
var GlyphQueries=getDisplayNames(Folder(QueriesFolderName+"/Glyph").getFiles("*.xml"));
var TransliterateQueries=getDisplayNames(Folder(QueriesFolderName+"/Transliterate").getFiles("*.xml"));
//var TextQueries=["テキストクエリ名１","テキストクエリ名２"];
//var GREPQueries=["正規表現クエリ名１","正規表現クエリ名２"];
//var GlyphQueries=["字形クエリ名１","字形クエリ名２"];
//var TransliterateQueries=["文字種変換クエリ名１","文字種変換クエリ名２"];

//クエリ追加
//TextQueries=TextQueries.concat([]);
GREPQueries=GREPQueries.concat(["末尾の空白文字を削除","複数改行から単一改行"]);
//GlyphQueries=GlyphQueries.concat([]);
//TransliterateQueries=TransliterateQueries.concat([]);


//メニュー作成
AddChangeMenu(TextQueries,SearchModes.TEXT_SEARCH,"changeText");
ChangeMenu.menuSeparators.add();
AddChangeMenu(GREPQueries,SearchModes.GREP_SEARCH,"changeGrep");
ChangeMenu.menuSeparators.add();
AddChangeMenu(GlyphQueries,SearchModes.GLYPH_SEARCH,"changeGlyph");
ChangeMenu.menuSeparators.add();
AddChangeMenu(TransliterateQueries,SearchModes.TRANSLITERATE_SEARCH,"changeTransliterate");
ChangeMenu.menuSeparators.add();

//任意のメニューを追加
var MenuNames=["$ID/To Uppercase","$ID/To Lowercase"];
for (var i=0;i<MenuNames.length;i++) {
    ChangeMenu.menuItems.add(app.menuActions.item(MenuNames[i]));
}

function getDisplayNames(Files){
    var DisplayNames=[];
    for (var i=0;i<Files.length;i++) DisplayNames.push(Files[i].displayName.slice(0,-4));
    return DisplayNames;
}
function AddChangeMenu(myQueries,mySearchMode,fName){
    for (var i=0;i<myQueries.length;i++) {
        if (myQueries[i].constructor.name=="Object"){
            var myMenuAction=app.scriptMenuActions.add(myQueries[i].name,{label:"ChangeMenu"});
            myMenuAction.addEventListener("onInvoke",TextChangeFunc(myQueries[i].query,mySearchMode,fName));
        } else {
            var myMenuAction=app.scriptMenuActions.add(myQueries[i],{label:"ChangeMenu"});
            myMenuAction.addEventListener("onInvoke",TextChangeFunc(myQueries[i],mySearchMode,fName));
        }
        ChangeMenu.menuItems.add(myMenuAction);
    }
}
function TextChangeFunc(QueryNames,mySearchMode,fName){
    if (QueryNames.constructor.name=="String") QueryNames=[QueryNames];
    return function (ev){
        if (app.activeDocument.selection.length==0) return;
        var Sel0=app.activeDocument.selection[0];
        if (Sel0.constructor.name=="InsertionPoint") Sel0=Sel0.parentStory;
        if (!Sel0.hasOwnProperty("changeGrep")||Sel0.contents.length==0) return;
        for (var i=0;i<QueryNames.length;i++) {
            app.loadFindChangeQuery(QueryNames[i],mySearchMode);
            Sel0[fName]();
        }
    }
}
})();